/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent.handlers;

import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.MidDialogRequestManager;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.DialogMethodHandler;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.InviteClientTransaction;
import net.sourceforge.peers.sip.transaction.InviteServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class CancelHandler
extends DialogMethodHandler
implements ServerTransactionUser {
    public CancelHandler(UserAgent userAgent, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, dialogManager, transactionManager, transportManager, logger);
    }

    public void handleCancel(SipRequest sipRequest) {
        SipHeaderFieldValue topVia = Utils.getTopVia(sipRequest);
        String branchId = topVia.getParam(new SipHeaderParamName("branch"));
        InviteServerTransaction inviteServerTransaction = (InviteServerTransaction)this.transactionManager.getServerTransaction(branchId, "INVITE");
        SipResponse cancelResponse = inviteServerTransaction == null ? this.buildGenericResponse(sipRequest, 481, "Call/Transaction Does Not Exist") : this.buildGenericResponse(sipRequest, 200, "OK");
        ServerTransaction cancelServerTransaction = this.transactionManager.createServerTransaction(cancelResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
        cancelServerTransaction.start();
        cancelServerTransaction.receivedRequest(sipRequest);
        cancelServerTransaction.sendReponse(cancelResponse);
        if (cancelResponse.getStatusCode() != 200) {
            return;
        }
        SipResponse lastResponse = inviteServerTransaction.getLastResponse();
        if (lastResponse != null && lastResponse.getStatusCode() >= 200) {
            return;
        }
        SipResponse inviteResponse = this.buildGenericResponse(inviteServerTransaction.getRequest(), 487, "Request Terminated");
        inviteServerTransaction.sendReponse(inviteResponse);
        Dialog dialog = this.dialogManager.getDialog(lastResponse);
        dialog.receivedOrSent300To699();
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.remoteHangup(sipRequest);
        }
    }

    public ClientTransaction preProcessCancel(SipRequest cancelGenericRequest, SipRequest inviteRequest, MidDialogRequestManager midDialogRequestManager) {
        InviteClientTransaction inviteClientTransaction;
        SipHeaders cancelHeaders = cancelGenericRequest.getSipHeaders();
        SipHeaders inviteHeaders = inviteRequest.getSipHeaders();
        SipHeaderFieldName cseqName = new SipHeaderFieldName("CSeq");
        SipHeaderFieldValue cancelCseq = cancelHeaders.get(cseqName);
        SipHeaderFieldValue inviteCseq = inviteHeaders.get(cseqName);
        cancelCseq.setValue(inviteCseq.getValue().replace("INVITE", "CANCEL"));
        SipHeaderFieldName fromName = new SipHeaderFieldName("From");
        SipHeaderFieldValue cancelFrom = cancelHeaders.get(fromName);
        SipHeaderFieldValue inviteFrom = inviteHeaders.get(fromName);
        cancelFrom.setValue(inviteFrom.getValue());
        SipHeaderParamName tagParam = new SipHeaderParamName("tag");
        cancelFrom.removeParam(tagParam);
        cancelFrom.addParam(tagParam, inviteFrom.getParam(tagParam));
        SipHeaderFieldValue topVia = Utils.getTopVia(inviteRequest);
        String branchId = topVia.getParam(new SipHeaderParamName("branch"));
        SipHeaderFieldName routeName = new SipHeaderFieldName("Route");
        SipHeaderFieldValue inviteRoute = inviteHeaders.get(routeName);
        if (inviteRoute != null) {
            cancelHeaders.add(routeName, inviteRoute);
        }
        if ((inviteClientTransaction = (InviteClientTransaction)this.transactionManager.getClientTransaction(inviteRequest)) != null) {
            SipResponse lastResponse = inviteClientTransaction.getLastResponse();
            if (lastResponse != null && lastResponse.getStatusCode() >= 200) {
                return null;
            }
        } else {
            this.logger.error("cannot retrieve invite client transaction for request " + inviteRequest);
        }
        return midDialogRequestManager.createNonInviteClientTransaction(cancelGenericRequest, branchId, midDialogRequestManager);
    }

    @Override
    public void transactionFailure() {
    }
}

